﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderNetworkMap
    {
        public static async Task<IQueryable<ProviderNetwork>> MapProviderNetworks(List<ppms_vaprovidernetwork> ppmsProviderNetworks, string mapRelatedType, PpmsContext context)
        {
            var providerNetworks = new List<ProviderNetwork> { };
            foreach (var ppmsProviderNetwork in ppmsProviderNetworks)
            {
               // var network = NetworkIds.GetNetwork(ppmsProviderNetwork.Id);

                var providerNetwork = new ProviderNetwork
                {
                    ProviderNetworkName = ppmsProviderNetwork.ppms_name,
                    ShortHand = ppmsProviderNetwork.ppms_shorthand,
                    NetworkId = ppmsProviderNetwork.ppms_networknumber.Value
                };


                if (ppmsProviderNetwork.ppms_operatingorganization != null)
                {
                    providerNetwork.OperatingOrganizationName = ppmsProviderNetwork.ppms_operatingorganization.Name;
                }

                if (ppmsProviderNetwork.ppms_VAProviderRelationshipId != null)
                {
                    providerNetwork.VaProviderRelationshipName = ppmsProviderNetwork.ppms_VAProviderRelationshipId.Name;
                }

                

                providerNetworks.Add(providerNetwork);
            }
            return providerNetworks.AsQueryable();
        }
    }
}